﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Icon Order class used for updating icons order index.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "IconOrder")]
    [DataContract(Name = "IconOrder")]
    public class IconOrder
    {
        /// <summary>
        /// Gets or sets the icon id.
        /// </summary>
        /// <value>
        /// The icon id.
        /// </value>
        [XmlElementAttribute("IconId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "IconId", Order = 1)]
        public int IconId { get; set; }

        /// <summary>
        /// Gets or sets the index of the order.
        /// </summary>
        /// <value>
        /// The index of the order.
        /// </value>
        [XmlElementAttribute("OrderIndex", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "OrderIndex", Order = 2)]
        public int OrderIndex { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 3)]
        public II FacilityId { get; set; }
    }
}
